<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Http\Controllers\Controller;
use App\Http\Resources\Web\ModulesResource;
use App\Http\Resources\Web\PricingPlansResource;
use App\Models\Therapist;
use App\Models\TherapistCommunity;
use App\Models\PricingPlan;
use App\Models\PricingPlanModule;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Laravel\Cashier\Cashier;

class PricingPlansController extends Controller
{
    public function __construct()
    {
    }

    public function index(Request $request,$type)
    {
        if ($request && $request != null) {
            $user = User::find($request->user_id);
            if ($user) {
                Auth::login($user);
                $user = Auth()->user();
                $request->session()->regenerate();
                $request->session()->put('logged_in_as', $type);
            }
        }
        if($type == 'therapist'){
            $pricing_plans = PricingPlan::with('modules')->therapist()->active()->get();
            $pricing_plans = PricingPlansResource::collection($pricing_plans);
            $modules = PricingPlanModule::therapist()->orderBy('sort_order','asc')->get();
            $modules = ModulesResource::collection($modules);
        }
        else if($type == 'therapist_community'){
            $pricing_plans = PricingPlan::with('modules')->therapistCommunity()->active()->get();
            $pricing_plans = PricingPlansResource::collection($pricing_plans);
            $modules = PricingPlanModule::therapistCommunity()->orderBy('sort_order','asc')->get();
            $modules = ModulesResource::collection($modules);
        }else{

        }

        return Inertia::render('PricingPlan/Listing',[
            'pricing_plans' => $pricing_plans,
            'modules' => $modules
        ]);
    }

    public function show(Request $request,$type,$slug)
    {
        $settings = generalSettings();
        $user = auth()->user();
        if(!$user){
            session([$type.'-'.'pricing-plan' => $slug]);
            return redirect()->route('register',['tab' => $type]);
        }
        $logged_in_as = $request->session()->get('logged_in_as');
        if($type == 'therapist'){
            config(['cashier.model' => 'App\Models\Therapist']);
            $therapist = $user->therapist;
            if($therapist && $logged_in_as == 'therapist'){
                $pricing_plan = PricingPlan::with('modules')->therapist()->active()->where('slug',$slug)->first();
                if($pricing_plan->is_paid && $settings['stripe_key']){
                    $intent = $therapist->createSetupIntent();
                }
                $pricing_plan = new PricingPlansResource($pricing_plan);
                $modules = PricingPlanModule::therapist()->orderBy('sort_order','asc')->get();
                $modules = ModulesResource::collection($modules);
            }else{
                request()->session()->flash('alert', [
                    'type' => 'info',
                    'message' => 'Please Switch To Therapist Profile For Therapist Subscriptions',
                ]);
                return redirect()->back();
            }
        }
        else if($type == 'therapist_community'){
            config(['cashier.model' => 'App\Models\TherapistCommunity']);
            $therapist_community = $user->therapist_community;
            if($therapist_community && $logged_in_as == 'therapist_community'){
                $pricing_plan = PricingPlan::with('modules')->therapistCommunity()->where('slug',$slug)->active()->first();
                if($pricing_plan->is_paid && $settings['stripe_key']){
                    $intent = $therapist_community->createSetupIntent();
                }
                $pricing_plan = new PricingPlansResource($pricing_plan);
                $modules = PricingPlanModule::therapistCommunity()->orderBy('sort_order','asc')->get();
                $modules = ModulesResource::collection($modules);
            }else{
                request()->session()->flash('alert', [
                    'type' => 'info',
                    'message' => 'Please Switch To TherapistCommunity Profile For TherapistCommunity Subscriptions',
                ]);
                return redirect()->back();
            }
        }else{
            abort(404);
        }

        return Inertia::render('PricingPlan/Detail',[
            'pricing_plan' => $pricing_plan,
            'modules' => $modules,
            'intent' => $intent ?? null
        ]);
    }

    public function subscription(Request $request,$type,$slug)
    {
        $user = auth()->user();
        if(!$user){
            session([$type.'-'.'pricing-plan' => $slug]);
            return redirect()->route('register',['tab' => $type]);
        }
        $logged_in_as = $request->session()->get('logged_in_as');
        if($type == 'therapist'){
            config(['cashier.model' => 'App\Models\Therapist']);
            Cashier::useCustomerModel(Therapist::class);
            $therapist = $user->therapist;
            if($therapist && $logged_in_as == 'therapist'){
                $pricing_plan = PricingPlan::with('modules')->therapist()->where('slug',$slug)->active()->first();
                if($pricing_plan->is_paid){
                    $subscription = $therapist->newSubscription($pricing_plan->slug, $pricing_plan->stripe_plan)->create($request->token);
                    $therapist->update(['pricing_plan_id' => $pricing_plan->id]);
                }else{
                    $therapist->update(['pricing_plan_id' => $pricing_plan->id]);
                }
            }
        }
        if($type == 'therapist_community'){
            config(['cashier.model' => 'App\Models\TherapistCommunity']);
            Cashier::useCustomerModel(TherapistCommunity::class);
            $therapist_community = $user->therapist_community;
            if($therapist_community && $logged_in_as == 'therapist_community'){
                $pricing_plan = PricingPlan::with('modules')->therapistCommunity()->where('slug',$slug)->active()->first();
                if($pricing_plan->is_paid){
                    $subscription = $therapist_community->newSubscription($pricing_plan->slug, $pricing_plan->stripe_plan)->create($request->token);
                    $therapist_community->update(['pricing_plan_id' => $pricing_plan->id]);
                }else{
                    $therapist_community->update(['pricing_plan_id' => $pricing_plan->id]);
                }
            }
        }
        request()->session()->flash('alert', [
            'type' => 'info',
            'message' => 'Successfully Activated Subscription',
        ]);
        return redirect(route('pricing',['type' => $type]));
    }
}
